<?php

// Set default timezone
date_default_timezone_set('UTC');

// getting database configurations
require 'database.php';

// Setup database connection
$conn = new PDO("mysql:host=".$db_config['host'].";dbname=".$db_config['name'],$db_config['user'],$db_config['pass']);
$conn->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING);

// Get settings from database
$sql = $conn->query("SELECT * FROM config");
$config = $sql->fetch();

$globals = array(
	// Basic info
	'version' => '1.0',

	// Api urls
	'dmoz_search' => 'http://search.dmoz.org/cgi-bin/search?search=',
	'yahoo_directory_search' => 'http://search.yahoo.com/search/dir?p=',


	// Mysql queries
	'insert_query_sites' => 'INSERT INTO sites (domain, google_page_rank, alexa_rank, domain_created, facebook_likes, facebook_share, facebook_comment, google_plus, twitter, pinterest, delicious, stumbleupon, linkedin, google_backlinks, bing_backlinks, dmoz, yahoo_directory, google_indexed, whois_info, views, updated, added) 
							VALUES (:domain, :google_page_rank, :alexa_rank, :domain_created, :facebook_likes, :facebook_share, :facebook_comment, :google_plus, :twitter, :pinterest, :delicious, :stumbleupon, :linkedin, :google_backlinks, :bing_backlinks, :dmoz, :yahoo_directory, :google_indexed, :whois_info, :views, :updated, :added)',
	'update_query_sites' => 'UPDATE sites SET google_page_rank=:google_page_rank, alexa_rank=:alexa_rank, domain_created=:domain_created, facebook_likes=:facebook_likes, facebook_share=:facebook_share, facebook_comment=:facebook_comment, google_plus=:google_plus, twitter=:twitter, pinterest=:pinterest,
							 delicious=:delicious, stumbleupon=:stumbleupon, linkedin=:linkedin, google_backlinks=:google_backlinks, bing_backlinks=:bing_backlinks, dmoz=:dmoz, yahoo_directory=:yahoo_directory, google_indexed=:google_indexed, whois_info=:whois_info, updated=:updated WHERE domain=:domain',

	// Default script settings						 
	'buy_link'	=> 'http://bit.ly/webscanup',
	'pp_help_link'	=> 'http://www.websterfolks.com/threads/how-to-setup-pagepeeker-for-your-script.1785/',
	'addthis_disqus_help_link'	=> 'http://www.websterfolks.com/threads/how-to-set-3rd-party-services-for-your-script.1786/',
);

// Replace the file name to your language file. 
require 'lang/lang.en.php';


// Include the functions file
require 'functions.php';
